import 'package:flutter_riverpod/flutter_riverpod.dart';
import 'package:razinsoft_rider/data/services/navigation_service.dart';
import '../../../core/state/app_state.dart';
import '../../../data/models/wallet_model/wallet_model.dart';
import '../../../data/repositories/interfaces/wallet_repo_interface.dart';

class WalletsNotifier extends StateNotifier<AppState<WalletModel>> {
  final IWalletsRepo walletsRepo;
  final Ref ref;


  WalletsNotifier({
    required this.walletsRepo,
    required this.ref,
  }) : super(const AppState.initial());

  Future<void> getWallets() async {
    state = const AppState.loading();
    final result = await walletsRepo.getWallets();
    result.fold(
          (failure) => state = AppState.error(failure),
          (data) => state = AppState.success(data),
    );
  }

  Future<void> addBalance(String amount) async {
    state = const AppState.loading();
    final result = await walletsRepo.addBalance(amount: amount);
    result.fold(
          (failure) => state = AppState.error(failure),
          (data) {
            state = AppState.success(data);
            NavigationService.pop();
            getWallets();
          },
    );
  }
}


